import com.urbancode.air.*
import com.urbancode.air.plugin.fortify.*

final def isWindows = (System.getProperty('os.name') =~ /(?i)windows/).find()

final def workDir = new File('.').canonicalFile
final def out = System.out

final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def props = apTool.getStepProperties()
CommandHelper commandHelper = new CommandHelper(workDir)

final def serverUrl = props['automation/serverUrl']
final def username = props['automation/username']
final def password = props['automation/password']
final def accessToken = props['automation/accessToken']
final def commandPath = props['automation/commandPath'] ? props['automation/commandPath'] + File.separator : ''

final def reportName = props['reportName'] ? props['reportName'] : 'Fortify Report'
final def fvdlFile = props['fvdlFile'] ? props['fvdlFile'] : 'anthill_fortify_scan.fvdl'
final def projectName = props['projectName']
final def versionName = props['versionName']


def fortifyclient = isWindows ? 'fortifyclient.bat' : 'fortifyclient'
def commandLine = [commandPath + fortifyclient, 'uploadFPR', '-url', serverUrl]

if (accessToken) {
    commandLine << 'authtoken' << accessToken
}
else {
    commandLine << '-user' << username << '-password' << password
}

commandLine << '-project' << projectName << '-version' << versionName << '-f' << fvdlFile

commandHelper.runCommand("Uploading scan results to Fortify", commandLine)

def outputFile = new File(workDir, fvdlFile)
XmlHelper helper = new XmlHelper();
helper.uploadResult(reportName, outputFile);