/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.*
import com.urbancode.air.plugin.fortify.*

final def workDir = new File('.').canonicalFile
final def out = System.out

final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def props = apTool.getStepProperties()
CommandHelper commandHelper = new CommandHelper(workDir)

final def commandPath = props['automation/commandPath'] ? props['automation/commandPath'] + File.separator : ''

final def reportName = props['reportName'] ? props['reportName'] : 'Fortify Report'
final def buildId = props['buildId']
final def fvdlFile = props['fvdlFile'] ?: 'ubuild_fortify_scan.fvdl'
final def javaMemorySetting = props['javaMemorySetting']
final def analyzerOptions = props['analyzerOptions']?.split('[ \n\r]')?.findAll{ it && it.trim().length() > 0}

def commandLine = [commandPath + 'sourceanalyzer', '-b', buildId]

if (analyzerOptions) {
    analyzerOptions.each { option ->
        commandLine << option
    }
}
if (javaMemorySetting) {
    commandLine << javaMemorySetting
}

commandLine << '-scan' << '-f' << fvdlFile

commandHelper.runCommand("Running scan with Fortify", commandLine)

def outputFile = new File(workDir, fvdlFile)
XmlHelper helper = new XmlHelper();
helper.uploadResult(reportName, outputFile);