'======================== Functions ========================
Dim tdConnection

Function disconnect()
	If IsObject(tdConnection) Then
		If tdConnection.Connected Then
			tdConnection.Disconnect()
			WScript.StdOut.WriteLine "Connection disconnected"
		End If
		If tdConnection.LoggedIn Then
			tdConnection.Logout()
			WScript.StdOut.WriteLine "Connection logged out"
		End If
		tdConnection.ReleaseConnection()
		WScript.StdOut.WriteLine "Connection released"
	End If
End Function

Function createConnection(serverUrl, username, password, domain, project)
	Dim connectionCreated
	connectionCreated = False
	
	Set tdConnection = CreateObject("TDApiOle80.TDConnection")

	If tdConnection Is Nothing Then
	  WScript.StdOut.WriteLine = "Failed to create TDApiOle80.TDConnection Object"
	Else
	  tdConnection.InitConnectionEx(serverUrl)
	  If tdConnection.Connected = False Then
		WScript.StdOut.WriteLine "Connection failed to Quality Center server " & serverUrl
	  Else
		WScript.StdOut.WriteLine "Connection created to Quality Center server " & serverUrl
		tdConnection.Login username, password
		If tdConnection.LoggedIn = False Then
		  WScript.StdOut.WriteLine "Connection failed to log in as user " & username
		Else
		  WScript.StdOut.WriteLine "Connection logged in as user " & username
		  tdConnection.Connect domain, project
		  If tdConnection.ProjectConnected = False Then
			WScript.StdOut.WriteLine "Connection failed to open project " & domain & "\" & project
		  Else
			WScript.StdOut.WriteLine "Connection opened project " & domain & "\" & project
			connectionCreated = True
		  End If
		End If
	  End If
	End If
	
	If Not connectionCreated Then
		disconnect()
	End If
	
	createConnection = connectionCreated
End Function

'======================== Main Script ========================
Dim args
Set args = WScript.Arguments
serverUrl = args.Item(0)
username = args.Item(1)
password = args.Item(2)
domain = args.Item(3)
project = args.Item(4)
testSetPath = args.Item(5)
testSetName = args.Item(6)
outputFile = args.Item(7)
remoteHost = ""
If args.Count > 8 Then
    remoteHost = args.Item(8)
End If

' prepend Root\ to the testSetPath if it is not already there
If InStr(testSetPath, "Root\") = 0 Then
	testSetPath = "Root\" & testSetPath
End If 

connectionCreated = createConnection(serverUrl, username, password, domain, project)
If Not connectionCreated Then
	WScript.Quit 1
End If

Dim testSetTreeManager
Set testSetTreeManager = tdConnection.TestSetTreeManager

Dim testSetFolder
Set testSetFolder = testSetTreeManager.NodeByPath(testSetPath)

Dim testSetList 
Set testSetList = testSetFolder.FindTestSets(testSetName)

If testSetList.Count = 0 Then
    WScript.StdOut.WriteLine "Test Set named '" & testSetName & "' not found."
ElseIf testSetList.Count > 1 Then
    WScript.StdOut.WriteLine "Multiple Test Sets named '" & testSetName & "' were found."
End If

Dim testSet
Set testSet = testSetList.Item(1)
WScript.StdOut.WriteLine "Found test set " & testSet.ID & " for " & testSetPath & "\" & testSetName

Dim scheduler
Set scheduler = testSet.StartExecution("")
If IsNull(scheduler) Then
    WScript.StdOut.WriteLine "Scheduler could not be created!"
    WScript.Quit 1
End If

If Len(remoteHost) = Null Or Len(remoteHost) = 0 Then
    WScript.StdOut.WriteLine "Running test set locally"
    scheduler.RunAllLocally = True
Else
    WScript.StdOut.WriteLine "Running test set remotely on " & remoteHost
    scheduler.TdHostName = remoteHost
End If

WScript.StdOut.WriteLine "Running test set " & testSet.ID & " - " & testSetPath & "\" & testSetName
scheduler.run

Dim executionStatus
Set executionStatus = scheduler.ExecutionStatus

WScript.StdOut.WriteLine ""
WScript.StdOut.WriteLine "Test Activity:"

Dim statusDictionary
Set statusDictionary = CreateObject("Scripting.Dictionary")

Dim executionStatusItem, executingTest, executionStatusString
Do Until executionStatus.Finished
    WScript.Sleep( 5000 )
	executionStatus.RefreshExecStatusInfo "all", true
    Set eventList = executionStatus.EventsList()
    For i = 1 To executionStatus.Count
		Set executionStatusItem = executionStatus.Item(i)
		Set executingTest = testSet.TSTestFactory.Item(executionStatusItem.TSTestId)
		executionStatusString = executionStatusItem.Status
		status = executionStatusItem.TSTestId & " - " & executingTest.Name & " - " & _
			executionStatusItem.Status & " - " & executionStatusItem.Message
		lastStatus = statusDictionary.Item(executionStatusItem.TSTestId)
		
		If Not status = lastStatus Then
			statusDictionary.Remove executionStatusItem.TSTestId
			statusDictionary.Add executionStatusItem.TSTestId, status
			WScript.StdOut.WriteLine "   " & status
		End If
    Next
    
Loop

WScript.StdOut.WriteLine ""
WScript.StdOut.WriteLine "Test Summary:"

totalTests = executionStatus.Count
testsPassed = 0
For i = 1 To totalTests
    Set executionStatusItem = executionStatus.Item(i)
	Set executingTest = testSet.TSTestFactory.Item(executionStatusItem.TSTestId)
	WScript.StdOut.WriteLine "   " & executionStatusItem.TSTestId & " - " & executingTest.Name & " - " & _
		executionStatusItem.Status & " - " & executionStatusItem.Message
    If StrComp(executionStatusItem.Status, "FinishedPassed") Then
        testsPassed = testsPassed + 1
    End If
    
Next

Set fileSystemObject = CreateObject("Scripting.FileSystemObject")
Set textFile = fileSystemObject.OpenTextFile(outputFile, 2, True)
textFile.WriteLine "Total Tests: " & totalTests
textFile.Write     "Tests Passed: " & testsPassed
textFile.Close

WScript.StdOut.WriteLine ""

disconnect()
WScript.Quit(-666)