import com.urbancode.air.*
import com.urbancode.air.plugin.automation.*

final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def workDir = new File('.').canonicalFile
def stepProps = apTool.getStepProperties()

def dir = new File(workDir, stepProps['workDirOffset'] ?: '.').canonicalFile

def serverUrl = stepProps['automation/serverUrl']
def username = stepProps['automation/username']
def password = stepProps['automation/password'] ? stepProps['automation/password'] : stepProps['automation/passwordscript']

def domain = stepProps['qcdomain']
def project = stepProps['qcproject']
def bugPattern = stepProps['bugpattern']
def failMode = stepProps['failmode']
def additionalComments = stepProps['additionalcomments']

QCAddComments comment = new QCAddComments()
comment.serverUrl = serverUrl
comment.username = username
comment.password = password
comment.domain = domain
comment.project = project

comment.bugPattern = bugPattern
comment.failMode = failMode
comment.additionalComments = additionalComments ?: ""

comment.workDir = dir

comment.execute()