import com.urbancode.air.*
import com.urbancode.air.plugin.automation.*

final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def workDir = new File('.').canonicalFile
def stepProps = apTool.getStepProperties()

def dir = new File(workDir, stepProps['workDirOffset'] ?: '.').canonicalFile

def serverUrl = stepProps['automation/serverUrl']
def username = stepProps['automation/username']
def password = stepProps['automation/password'] ? stepProps['automation/password'] : stepProps['automation/passwordscript']

def domain = stepProps['qcdomain']
def project = stepProps['qcproject']
def folder = stepProps['folder']
def testSetName = stepProps['testSetName']
def remoteHost = stepProps['remotehost']
def threshold = Integer.valueOf(stepProps['threshold'] ?: 100)

QCRunTest runTest = new QCRunTest()
runTest.serverUrl = serverUrl
runTest.username = username
runTest.password = password
runTest.domain = domain
runTest.project = project

runTest.folder = folder
runTest.testSetName = testSetName
runTest.remoteHost = remoteHost
runTest.threshold = threshold

runTest.workDir = dir

System.exit(runTest.execute())