' Licensed Materials - Property of IBM Corp.
' IBM UrbanCode Build
' (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
'
' U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
' GSA ADP Schedule Contract with IBM Corp.
'======================== Constants ========================

COMMENT_LINE = "<b>________________________________________</b>"
FONT_OPEN_ELEMENT = "<font color=""#000080"">"
FONT_CLOSE_ELEMENT = "</font>"
HTML_OPEN_ELEMENT = "<html>"
HTML_CLOSE_ELEMENT = "</html>"
BODY_OPEN_ELEMENT = "<body>"
BODY_CLOSE_ELEMENT = "</body>"
COMMENT_SEPERATOR = FONT_OPEN_ELEMENT & COMMENT_LINE & FONT_CLOSE_ELEMENT
LESS_THAN_CHAR = "&lt;"
GREATER_THAN_CHAR = "&gt;"
BREAK_ELEMENT = "<br>"
BOLD_OPEN_ELEMENT = "<b>"
BOLD_CLOSE_ELEMENT = "</b>"

'======================== Functions ========================
Dim tdConnection

Function disconnect()
	If IsObject(tdConnection) Then
		If tdConnection.Connected Then
			tdConnection.Disconnect()
			WScript.StdOut.WriteLine "Connection disconnected"
		End If
		If tdConnection.LoggedIn Then
			tdConnection.Logout()
			WScript.StdOut.WriteLine "Connection logged out"
		End If
		tdConnection.ReleaseConnection()
		WScript.StdOut.WriteLine "Connection released"
	End If
End Function

Function createConnection(serverUrl, username, password, domain, project)
	Dim connectionCreated
	connectionCreated = False
	
	Set tdConnection = CreateObject("TDApiOle80.TDConnection")

	If tdConnection Is Nothing Then
	  WScript.StdOut.WriteLine = "Failed to create TDApiOle80.TDConnection Object"
	Else
	  tdConnection.InitConnectionEx(serverUrl)
	  If tdConnection.Connected = False Then
		WScript.StdOut.WriteLine "Connection failed to Quality Center server " & serverUrl
	  Else
		WScript.StdOut.WriteLine "Connection created to Quality Center server " & serverUrl
		tdConnection.Login username, password
		If tdConnection.LoggedIn = False Then
		  WScript.StdOut.WriteLine "Connection failed to log in as user " & username
		Else
		  WScript.StdOut.WriteLine "Connection logged in as user " & username
		  tdConnection.Connect domain, project
		  If tdConnection.ProjectConnected = False Then
			WScript.StdOut.WriteLine "Connection failed to open project " & domain & "\" & project
		  Else
			WScript.StdOut.WriteLine "Connection opened project " & domain & "\" & project
			connectionCreated = True
		  End If
		End If
	  End If
	End If
	
	If Not connectionCreated Then
		disconnect()
	End If
	
	createConnection = connectionCreated
End Function

Function readFile(filePath)
    dim objFSO, objFile, fileContent
    set objFSO = CreateObject("Scripting.FileSystemObject")
    set objFile = objFSO.openTextFile(filePath, 1)
    fileContent = ""
    Do Until objFile.atEndOfStream
        fileContent = fileContent & objFile.readLine & vbCrLf
    Loop
    objFile.close
    Set objFile = Nothing
    Set objFSO = Nothing
    readFile = fileContent
End Function
 
'======================== Main Script ========================
Dim args
Set args = WScript.Arguments
serverUrl = args.Item(0)
username = args.Item(1)
password = args.Item(2)
domain = args.Item(3)
project = args.Item(4)
bugId = args.Item(5)
commentFileName = args.Item(6)
comment = readFile(commentFileName)

connectionCreated = createConnection(serverUrl, username, password, domain, project)
If Not connectionCreated Then
	WScript.Quit 1
End If

Dim bugFactory
Set bugFactory = tdConnection.BugFactory

Dim bug
Set bug = bugFactory.Item(bugId)
If IsNull(bug) Then
	WScript.StdOut.WriteLine "Warning: no defect found for id " & bugId
Else
	WScript.StdOut.WriteLine "Adding comment to defect " & bugId & ": " & comment
	
	existingComments = bug.Field("BG_DEV_COMMENTS")
	
	Dim newComment
	if IsNull(existingComments) Or Len(existingComments) = 0 Or existingComments = "null" Then
		newComment = "<html><body>" & comment & "</body></html>"
	Else
		insertIndex = InStr(existingComments, BODY_CLOSE_ELEMENT)
		prefix = Left(existingComments, insertIndex - 1)
		suffix = Right(existingComments, Len(existingComments) - insertIndex + 1)
		newComment = prefix & BREAK_ELEMENT & COMMENT_SEPERATOR & BREAK_ELEMENT & comment & suffix
	End If
	bug.Field("BG_DEV_COMMENTS") = newComment
	
	WScript.StdOut.WriteLine "Posting comment to defect " & bugId & ": " & newComment
	bug.Post()
	bug.UnlockObject()
	WScript.StdOut.WriteLine "Post complete"
End If

disconnect()
WScript.Quit(-666)
