/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
package com.urbancode.air.plugin.automation;

import com.urbancode.air.*

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class AutomationBase {
    //**************************************************************************
    // CLASS
    //**************************************************************************

    //**************************************************************************
    // INSTANCE
    //**************************************************************************
    String serverUrl
    String username
    String password
    String domain
    String project
    
    def workDir
    CommandHelper cmdHelper
    def cscriptExe = "cscript.exe"
    final def PLUGIN_HOME = System.getenv('PLUGIN_HOME')
    final def JACOB_HOME = PLUGIN_HOME + File.separator + "lib" + File.separator + "dll"
    final int SUCCESS_CODE = -666
    
    protected void init() {
        cmdHelper = new CommandHelper(workDir)
        cmdHelper.ignoreExitValue = true
        cmdHelper.addEnvironmentVariable("JAVA_OPTS", "-Djava.library.path=$JACOB_HOME")
        
        if (new File("C:\\Windows\\SysWOW64").exists()) {
            cscriptExe = "C:\\Windows\\SysWOW64\\cscript.exe"
        }
    }
    
    protected void runCommand(message, command) {
        int exitCode = cmdHelper.runCommand(message, command)
        if (exitCode != SUCCESS_CODE) {
            throw new ExitCodeException("Invalid exit code: " + exitCode + ". Expected exit code " + SUCCESS_CODE)
        }
    }
    
    protected String createHtmlFormattedComment(String username, String comment) {
        
        // it wasn't finding these... so I made it find them here
        final def COMMENT_LINE = "<b>________________________________________</b>";
        final def FONT_OPEN_ELEMENT = "<font color=\"#000080\">";
        final def FONT_CLOSE_ELEMENT = "</font>";
        final def HTML_OPEN_ELEMENT = "<html>";
        final def HTML_CLOSE_ELEMENT = "</html>";
        final def BODY_OPEN_ELEMENT = "<body>";
        final def BODY_CLOSE_ELEMENT = "</body>";
        final def COMMENT_SEPERATOR = FONT_OPEN_ELEMENT + COMMENT_LINE + FONT_CLOSE_ELEMENT;
        final def LESS_THAN_CHAR = "&lt;";
        final def GREATER_THAN_CHAR = "&gt;";
        final def BREAK_ELEMENT = "<br>";
        final def BOLD_OPEN_ELEMENT = "<b>";
        final def BOLD_CLOSE_ELEMENT = "</b>";
        
        StringBuffer result  = new StringBuffer();
    
        Date currentDate = new Date();
    
        result.append(FONT_OPEN_ELEMENT);
        result.append(BOLD_OPEN_ELEMENT);
        result.append("uBuild");
        result.append(LESS_THAN_CHAR);
        result.append(username);
        result.append(GREATER_THAN_CHAR);
        result.append(", ");
        result.append(formatDate(currentDate));
        result.append(": ");
        result.append(BOLD_CLOSE_ELEMENT);
        result.append(FONT_CLOSE_ELEMENT);
        result.append(comment);
        
        return result.toString();
    }
    
    protected String formatDate(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
        dateFormat.setTimeZone(TimeZone.getDefault());
        return dateFormat.format(date);
    }
    
}