' Licensed Materials - Property of IBM Corp.
' IBM UrbanCode Build
' (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
'
' U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
' GSA ADP Schedule Contract with IBM Corp.
'======================== Functions ========================
Dim tdConnection

Function disconnect()
	If IsObject(tdConnection) Then
		If tdConnection.Connected Then
			tdConnection.Disconnect()
			WScript.StdOut.WriteLine "Connection disconnected"
		End If
		If tdConnection.LoggedIn Then
			tdConnection.Logout()
			WScript.StdOut.WriteLine "Connection logged out"
		End If
		tdConnection.ReleaseConnection()
		WScript.StdOut.WriteLine "Connection released"
	End If
End Function

Function createConnection(serverUrl, username, password, domain, project)
	Dim connectionCreated
	connectionCreated = False
	
	Set tdConnection = CreateObject("TDApiOle80.TDConnection")

	If tdConnection Is Nothing Then
	  WScript.StdOut.WriteLine = "Failed to create TDApiOle80.TDConnection Object"
	Else
	  tdConnection.InitConnectionEx(serverUrl)
	  If tdConnection.Connected = False Then
		WScript.StdOut.WriteLine "Connection failed to Quality Center server " & serverUrl
	  Else
		WScript.StdOut.WriteLine "Connection created to Quality Center server " & serverUrl
		tdConnection.Login username, password
		If tdConnection.LoggedIn = False Then
		  WScript.StdOut.WriteLine "Connection failed to log in as user " & username
		Else
		  WScript.StdOut.WriteLine "Connection logged in as user " & username
		  tdConnection.Connect domain, project
		  If tdConnection.ProjectConnected = False Then
			WScript.StdOut.WriteLine "Connection failed to open project " & domain & "\" & project
		  Else
			WScript.StdOut.WriteLine "Connection opened project " & domain & "\" & project
			connectionCreated = True
		  End If
		End If
	  End If
	End If
	
	If Not connectionCreated Then
		disconnect()
	End If
	
	createConnection = connectionCreated
End Function
 
'======================== Main Script ========================
Dim args
Set args = WScript.Arguments
serverUrl = args.Item(0)
username = args.Item(1)
password = args.Item(2)
domain = args.Item(3)
project = args.Item(4)

connectionCreated = createConnection(serverUrl, username, password, domain, project)
If Not connectionCreated Then
	WScript.Quit 1
End If

Dim bugFactory
Set bugFactory = tdConnection.BugFactory

Dim bug
Set bug = bugFactory.AddItem(Null)
WScript.StdOut.WriteLine "Creating defect " & bug.Field("BG_BUG_ID")

Dim fieldName, fieldValue, argsCount
fieldName = Null
argsCount = args.Count - 1
For argumentIndex = 5 To argsCount
	If IsNull(fieldName) Then
		fieldName = Replace(args.Item(argumentIndex), "'", """")
	Else
		fieldValue = args.Item(argumentIndex)
		WScript.StdOut.WriteLine "Setting defect " & fieldName & " to " & fieldValue
		Execute "bug." & fieldName & " = fieldValue"
		fieldName = Null
		fieldValue = Null
	End If
Next

WScript.StdOut.WriteLine "Posting changes to defect " & bug.Field("BG_BUG_ID")
bug.Post()
bug.UnlockObject()
WScript.StdOut.WriteLine "Post complete"

disconnect()
WScript.Quit(-666)
