/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
package com.urbancode.air.plugin.automation

public class QCRunTest extends AutomationBase {

    String folder
    String testSetName
    String remoteHost
    int threshold

    public int execute() {
        init()

        def command = generateCommand()
        def outputText
        runCommand("Running Test Set", command) { Process proc ->
            proc.out.close() // close stdin
            proc.consumeProcessErrorStream(System.out) // forward stderr
            outputText = proc.text.trim()
            println outputText
        }

        return verifyThresholdPassed(outputText)
    }

    private def generateCommand() {
        def command = [cscriptExe]
        command << PLUGIN_HOME + "\\qc_run_test_set.vbs"
        command << serverUrl
        command << username
        command << password
        command << domain
        command << project
        command << folder
        command << testSetName
        if (remoteHost) {
            command << remoteHost
        }

        return command
    }

    private int verifyThresholdPassed(String output) {
        def found = false
        int totalTests = 0
        int testsPassed = 0
        output.eachLine {
            if (!found) {
                found = it =~ 'Test Summary'
            }
            else {
                // Once we find Test Summary, the rest of the output is whether a test passed or failed
                totalTests++
                boolean passed = it =~ 'FinishedPassed'
                if (passed) {
                    testsPassed++
                }
            }
        }

        int percentPass = ((double) testsPassed / (double) totalTests) * 100

        if (percentPass < threshold) {
            println("Not enough tests were successful. The threshold was ${threshold} and the " +
                "passing percentage was ${percentPass}")
            return 1
        }
        return 0
    }
}
