/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.*
import com.urbancode.air.plugin.automation.*

import java.text.SimpleDateFormat
import java.util.Date
import java.util.TimeZone

final def apTool = new AirPluginTool(this.args[0], this.args[1])
def stepProps = apTool.getStepProperties()

final def dir = new File('.').canonicalFile

def serverUrl           = stepProps['automation/serverUrl']
def username            = stepProps['automation/username']
def password            = stepProps['automation/password'] ?: stepProps['automation/passwordscript']
def domain              = stepProps['qcdomain']
def project             = stepProps['qcproject']
def fieldName           = stepProps['fieldName']
def fieldValue          = stepProps['fieldValue']
def useHistory          = Boolean.valueOf(stepProps['useHistory'])
def requireAllValues    = Boolean.valueOf(stepProps['requireAllValues'])


QCVerifyIssues verify = new QCVerifyIssues()
verify.serverUrl = serverUrl
verify.username = username
verify.password = password
verify.domain = domain
verify.project = project

verify.fieldName = fieldName
verify.fieldValue = fieldValue
verify.useHistory = useHistory
verify.requireAllValues = requireAllValues

verify.workDir = dir

verify.execute()