/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.*
import com.urbancode.air.plugin.automation.*

final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def workDir = new File('.').canonicalFile
def stepProps = apTool.getStepProperties()

def dir = new File(workDir, stepProps['workDirOffset'] ?: '.').canonicalFile

def serverUrl = stepProps['automation/serverUrl']
def username = stepProps['automation/username']
def password = stepProps['automation/password'] ? stepProps['automation/password'] : stepProps['automation/passwordscript']

def domain          = stepProps['qcdomain']
def project         = stepProps['qcproject']
def assignee        = stepProps['assignee']
def summary         = stepProps['summary']
def priority        = stepProps['priority']
def status          = stepProps['status']
def severity        = stepProps['severity']
def qcProjectKey    = stepProps['qcprojectkey']
def detectedBy      = stepProps['detectedby']
def detectedOn      = stepProps['detectedon']

def issuePropsStr = stepProps['props']

QCCreate create = new QCCreate()
create.serverUrl = serverUrl
create.username = username
create.password = password
create.domain = domain
create.project = project

create.assignee = assignee
create.summary = summary
create.priority = priority
create.status = status
create.severity = severity
create.qcProjectKey = qcProjectKey
create.detectedBy = detectedBy
create.detectedOn = detectedOn

create.issuePropsStr = issuePropsStr

create.workDir = dir

create.execute()