' Licensed Materials - Property of IBM Corp.
' IBM UrbanCode Build
' (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
'
' U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
' GSA ADP Schedule Contract with IBM Corp.
'======================== Functions ========================
Dim tdConnection

Function disconnect()
	If IsObject(tdConnection) Then
		If tdConnection.Connected Then
			tdConnection.Disconnect()
			WScript.StdOut.WriteLine "Connection disconnected"
		End If
		If tdConnection.LoggedIn Then
			tdConnection.Logout()
			WScript.StdOut.WriteLine "Connection logged out"
		End If
		tdConnection.ReleaseConnection()
		WScript.StdOut.WriteLine "Connection released"
	End If
End Function

Function createConnection(serverUrl, username, password, domain, project)
	Dim connectionCreated
	connectionCreated = False
	
	Set tdConnection = CreateObject("TDApiOle80.TDConnection")

	If tdConnection Is Nothing Then
	  WScript.StdOut.WriteLine = "Failed to create TDApiOle80.TDConnection Object"
	Else
	  tdConnection.InitConnectionEx(serverUrl)
	  If tdConnection.Connected = False Then
		WScript.StdOut.WriteLine "Connection failed to Quality Center server " & serverUrl
	  Else
		WScript.StdOut.WriteLine "Connection created to Quality Center server " & serverUrl
		tdConnection.Login username, password
		If tdConnection.LoggedIn = False Then
		  WScript.StdOut.WriteLine "Connection failed to log in as user " & username
		Else
		  WScript.StdOut.WriteLine "Connection logged in as user " & username
		  tdConnection.Connect domain, project
		  If tdConnection.ProjectConnected = False Then
			WScript.StdOut.WriteLine "Connection failed to open project " & domain & "\" & project
		  Else
			WScript.StdOut.WriteLine "Connection opened project " & domain & "\" & project
			connectionCreated = True
		  End If
		End If
	  End If
	End If
	
	If Not connectionCreated Then
		disconnect()
	End If
	
	createConnection = connectionCreated
End Function

'======================== Main Script ========================
Dim args
Set args = WScript.Arguments
serverUrl = args.Item(0)
username = args.Item(1)
password = args.Item(2)
domain = args.Item(3)
project = args.Item(4)
bugIdAndChangeIds = args.Item(5)
outputFile = args.Item(6)

WScript.StdOut.WriteLine "Getting defects details for " & bugIdAndChangeIds

connectionCreated = createConnection(serverUrl, username, password, domain, project)
If Not connectionCreated Then
	WScript.Quit 1
End If

Dim bugFactory
Set bugFactory = tdConnection.BugFactory

Dim bug
Set fileSystemObject = CreateObject("Scripting.FileSystemObject")
Set textFile = fileSystemObject.OpenTextFile(outputFile, 2, True)
textFile.WriteLine "<issues>"
bugIdAndChangeIdsArray = Split(bugIdAndChangeIds, ",")
For Each bugIdAndChangeId In bugIdAndChangeIdsArray
    bugIdAndChangeIdArray = Split(bugIdAndChangeId, "|")
    bugId = bugIdAndChangeIdArray(0)
    changeId = bugIdAndChangeIdArray(1)
	WScript.StdOut.WriteLine "Getting defect " & bugId & " for source change " & changeId
    
    Set bug = bugFactory.Item(bugId)
    If IsNull(bug) Then
    	WScript.StdOut.WriteLine "Warning: no defect found for id " & bugId
    Else
    	WScript.StdOut.WriteLine "Found defect for id " & bugId
    	
    	bgDesc = bug.Field("BG_DESCRIPTION")
        If Not IsNull(bgDesc) Then
            ' HTML replacement on the description
            bgDesc = Replace(bgDesc, "<html>", "")
            bgDesc = Replace(bgDesc, "</html>", "")
            bgDesc = Replace(bgDesc, "<body>", "")
            bgDesc = Replace(bgDesc, "</body>", "")
            bgDesc = Replace(bgDesc, "<b>", "")
            bgDesc = Replace(bgDesc, "</b>", "")
            bgDesc = Replace(bgDesc, "<i>", "")
            bgDesc = Replace(bgDesc, "</i>", "")
            bgDesc = Replace(bgDesc, "<u>", "")
            bgDesc = Replace(bgDesc, "</u>", "")
            bgDesc = Replace(bgDesc, "<br>", "\n")
            bgDesc = Replace(bgDesc, "&lt;", "<")
            bgDesc = Replace(bgDesc, "&gt;", ">")
            bgDesc = Replace(bgDesc, "&amp;", "&")
            bgDesc = Replace(bgDesc, "&quot;", """")
        End If

		textFile.WriteLine "  <issue id=""" & bugId & """ issue-tracker=""HP Quality Center"" change-id=""" & changeId & """>"
		textFile.WriteLine "    <name><![CDATA[" & bug.Summary & "]]></name>"
		textFile.WriteLine "    <type>Defect</type>"
		textFile.WriteLine "    <status><![CDATA[" & bug.Status & "]]></status>"
		textFile.WriteLine "    <description><![CDATA[" & bgDesc & "]]></description>"
		textFile.WriteLine "  </issue>"
    End If
Next

disconnect()

textFile.WriteLine "</issues>"
textFile.Close

WScript.Quit(-666)