/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2015. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
package com.urbancode.air.plugin.scm

class SCMCheckout extends SCMStep {

    //**************************************************************************
    // CLASS
    //**************************************************************************

    //**************************************************************************
    // INSTANCE
    //**************************************************************************

    Date date
    def version //Not used if methodOfCheckout is SYNCHRONIZE or UPDATE
    def snapshot
    def checkoutMethod
    def includeFiles

    void execute() {
        def logFile = File.createTempFile("hsv-", ".log", directory)
        logFile.deleteOnExit()
        def cmdArgs = commandHelperBase()

        cmdArgs << "-s"
        for (file in includeFiles) {
            cmdArgs << file
        }
        cmdArgs << checkoutMethod
        cmdArgs << "-cp"
        cmdArgs << "${directory.absolutePath}"
        if (snapshot) {
            cmdArgs << "-ss"
            cmdArgs << snapshot
        }
        if (!pkg) {
            if (checkoutMethod != '-br' && checkoutMethod != '-sy') {
                throw new Exception("Package must be present when ${checkoutMethod} flag is specified.")
            }
        }
        else {
            cmdArgs << "-p"
            cmdArgs << pkg
        }
        cmdArgs << "-o"
        cmdArgs << "${logFile.absolutePath}"

        cmdHelper.runCommand('Harvest Checkout', cmdArgs)
    }
}