/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Build
 * (c) Copyright IBM Corporation 2015. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
package com.urbancode.air.plugin.scm;

import java.text.DateFormat
import java.util.regex.Matcher
import com.urbancode.air.CommandHelper

class SCMStep {
    final def REPO_TYPE = 'harvest'
    def isWindows
    def out = System.out
    def cmdHelper

    File directory
    def scmCmd
    def commandPath
    def broker
    def username
    def password
    def project
    def viewPath
    def state
    def pkg

    /**
     * Print a message to the output stream of choice.
     * @param msg
     */
    protected void println(def msg) {
        out.println(msg)
    }

    protected DateFormat getDateArgumentFormatter() {
        DateFormat harvestDateFormat = new java.text.SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S Z")
        harvestDateFormat.timeZone = TimeZone.getTimeZone("GMT")
        return harvestDateFormat
    }

    /**
     *
     * @return base arguments used in harvest commands
     */
    def commandHelperBase() {
        cmdHelper = new CommandHelper()

        if (commandPath) {
            File path = new File(commandPath, scmCmd)
            if (path.exists() && path.isFile()) {
                scmCmd = path.absolutePath
            }
            else {
                throw new Exception("${path.absolutePath} does not exist.")
            }
        }

        def cmdArgs = [scmCmd, "-b", broker, "-en", project, "-vp", viewPath, "-st", state]

        if (username) {
            cmdArgs << "-usr"
            cmdArgs << username
        }
        if (password) {
            cmdArgs << "-pw"
            cmdArgs << password
        }
        return cmdArgs
    }
}
