/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2015. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
package com.urbancode.air.plugin.scm

import java.util.TimeZone
import java.text.SimpleDateFormat
import com.urbancode.air.plugin.scm.changelog.*


public class SCMQuietPeriod extends SCMChangelog {

    //**************************************************************************
    // CLASS
    //**************************************************************************

    //**************************************************************************
    // INSTANCE
    //**************************************************************************

    /**
     *
     * @return date of the last change
     */
    public def execute() {
        CHANGE_DATE_FORMAT.timeZone = TimeZone.getTimeZone("UTC")
        def logOutput = runLogCommand()
        changeSets = parseChangesets(logOutput);
        Date latestChangeDate = changeSets.collect{ChangeSet cs -> cs.date}.max();
        return latestChangeDate
    }
}