/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Build
 * (c) Copyright IBM Corporation 2015. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.scm.*
import com.urbancode.air.DateParser

final def workDir = new File('.').canonicalFile

//------------------------------------------------------------------------------
// GET ALL INPUT PARAMETERS
//------------------------------------------------------------------------------
final def dateParser = new DateParser()
final def apTool = new AirPluginTool(this.args[0], this.args[1])

final def stepProps = apTool.getStepProperties()

// Repo
final def commandPath = stepProps['source/repo/commandPath']
final def broker = stepProps['source/repo/broker']
final def username = stepProps['source/repo/username']
final def password = stepProps['source/repo/password'] ?: stepProps['source/repo/passScript']

// Source
final def srcName = stepProps['source'];
final def dir = new File(workDir, stepProps['source/dirOffset'] ?: '.').canonicalFile //log file directory
final def pkg = stepProps['source/package']
final def project = stepProps['source/project']
final def viewPath = stepProps['source/viewPath']
final def state = stepProps['source/state']
final String userExcludesString = stepProps['source/excludeUsers'] ?: ''
final String fileFiltersString  = stepProps['source/fileFilters'] ?: ''

// Step
final def startDate = dateParser.parseDate(stepProps['startDate'])
final def endDate = dateParser.parseDate(stepProps['endDate'])
final String changesUrl = stepProps['changesUrl']

//
// Perform step
//
dir.mkdirs()

SCMChangelog step = new SCMChangelog()
step.directory = dir
step.commandPath = commandPath
step.scmCmd = 'hsv'
step.broker = broker
step.username = username
step.password = password
step.project = project
step.viewPath = viewPath
step.state = state
step.pkg = pkg
step.startDate = startDate
step.endDate = endDate

step.changesUrl = changesUrl
step.changeSetFilter.setUserExcludes(userExcludesString)
step.changeSetFilter.setFileFilters(fileFiltersString)
step.execute()