/*
 * Licensed Materials - Property of IBM Corp. and/or HCL**
 * IBM UrbanCode Build
 * (c) Copyright IBM Corporation 2015, 2018. All Rights Reserved.
 * (c) Copyright HCL Corporation 2019 All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 *
 * * Trademark of International Business Machines
 * ** Trademark of HCL Technologies Limited
 */
import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.scm.SCMQuietPeriod
import com.urbancode.air.DateParser

File workDir = new File('.').canonicalFile

//------------------------------------------------------------------------------
// GET ALL INPUT PARAMETERS
//------------------------------------------------------------------------------
DateParser dateParser = new DateParser()
AirPluginTool apTool = new AirPluginTool(this.args[0], this.args[1])

Properties stepProps = apTool.getStepProperties()

// Repo
String commandPath = stepProps['source/repo/commandPath']
String broker = stepProps['source/repo/broker']
String username = stepProps['source/repo/username']
String password = stepProps['source/repo/password'] ?: stepProps['source/repo/passScript']

// Source
String srcName = stepProps['source'];
File dir = new File(workDir, stepProps['source/dirOffset'] ?: '.').canonicalFile //log file directory
String pkg = stepProps['source/package']
String project = stepProps['source/project']
String viewPath = stepProps['source/viewPath']
String state = stepProps['source/state']
String userExcludesString = stepProps['source/excludeUsers'] ?: ''
String fileFiltersString  = stepProps['source/fileFilters'] ?: ''


// quietPeriod
Date startDate = dateParser.parseDate(stepProps['startDate'])
Date endDate = dateParser.parseDate(stepProps['endDate'])

//
// Perform quietPeriod
//
dir.mkdirs()

SCMQuietPeriod quietPeriod = new SCMQuietPeriod()
quietPeriod.directory = dir
quietPeriod.commandPath = commandPath
quietPeriod.scmCmd = 'hsv'
quietPeriod.broker = broker
quietPeriod.username = username
quietPeriod.password = password
quietPeriod.project = project
quietPeriod.viewPath = viewPath
quietPeriod.state = state
quietPeriod.pkg = pkg
quietPeriod.startDate = startDate
quietPeriod.endDate = endDate

quietPeriod.changeSetFilter.setUserExcludes(userExcludesString)
quietPeriod.changeSetFilter.setFileFilters(fileFiltersString)

Date latestRevisionDate = quietPeriod.executeQuietPeriod()

//------------------------------------------------------------------------------
// UPLOAD LATEST CHANGE DATE
//------------------------------------------------------------------------------
if (latestRevisionDate) {
    apTool.setOutputProperty("job/latest.change.time.${srcName}", String.valueOf(latestRevisionDate.time))
    apTool.storeOutputProperties()
    println "Latest Revision Date: " + latestRevisionDate
}
else {
    println('No changes detected')
}