/*
 * Licensed Materials - Property of IBM Corp. and/or HCL**
 * IBM UrbanCode Build
 * (c) Copyright IBM Corporation 2015, 2018. All Rights Reserved.
 * (c) Copyright HCL Corporation 2019 All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 *
 * * Trademark of International Business Machines
 * ** Trademark of HCL Technologies Limited
 */
package com.urbancode.air.plugin.scm

import java.util.TimeZone
import java.text.SimpleDateFormat
import com.urbancode.air.plugin.scm.changelog.*


public class SCMQuietPeriod extends SCMChangelog {

    //**************************************************************************
    // CLASS
    //**************************************************************************

    //**************************************************************************
    // INSTANCE
    //**************************************************************************

    /**
     *
     * @return date of the last change
     */
    Date executeQuietPeriod() {
        CHANGE_DATE_FORMAT.timeZone = TimeZone.getTimeZone("UTC")
        String logOutput = runLogCommand()
        Collection<ChangeSet> changeSets = parseChangesets(logOutput);
        Date latestChangeDate = changeSets.collect{ChangeSet cs -> cs.date}.max();
        return latestChangeDate
    }
}