/*
 * Licensed Materials - Property of IBM Corp. and/or HCL**
 * IBM UrbanCode Build
 * (c) Copyright IBM Corporation 2015, 2018. All Rights Reserved.
 * (c) Copyright HCL Corporation 2019 All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 *
 * * Trademark of International Business Machines
 * ** Trademark of HCL Technologies Limited
 */
package com.urbancode.air.plugin.scm;

import java.text.DateFormat
import java.text.SimpleDateFormat
import com.urbancode.air.CommandHelper

class SCMStep {
    static public final boolean isWindows = (System.getProperty('os.name') =~ /(?i)windows/).find();

    final String REPO_TYPE = "harvest"
    PrintStream out = System.out
    CommandHelper cmdHelper

    File directory
    String scmCmd
    String commandPath
    String broker
    String username
    String password
    String project
    String viewPath
    String state
    String pkg

    /**
     * Print a message to the output stream of choice.
     * @param msg
     */
    protected void println(def msg) {
        out.println(msg)
    }

    protected DateFormat getDateArgumentFormatter() {
        DateFormat harvestDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S Z")
        harvestDateFormat.timeZone = TimeZone.getTimeZone("GMT")
        return harvestDateFormat
    }

    /**
     *
     * @return base arguments used in harvest commands
     */
    List commandHelperBase() {
        cmdHelper = new CommandHelper()

        String cmd = scmCmd;
        if (isWindows) {
            cmd += ".exe"
        }

        if (commandPath) {
            File path = new File(commandPath, cmd).absoluteFile;
            cmd = path.absolutePath;
            if (!path.exists()) {
                println("WARN ${cmd} does not seem to exist, attempting anyway.")
            }
        }

        List cmdArgs = [cmd, "-b", broker, "-en", project, "-vp", viewPath, "-st", state] as List

        if (username) {
            cmdArgs << "-usr"
            cmdArgs << username
        }
        if (password) {
            cmdArgs << "-pw"
            cmdArgs << password
        }
        return cmdArgs
    }
}
