/*
 * Licensed Materials - Property of IBM Corp. and/or HCL**
 * IBM UrbanCode Build
 * (c) Copyright IBM Corporation 2015, 2018. All Rights Reserved.
 * (c) Copyright HCL Corporation 2019 All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 *
 * * Trademark of International Business Machines
 * ** Trademark of HCL Technologies Limited
 */
import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.scm.SCMChangelog
import com.urbancode.air.DateParser

File workDir = new File('.').canonicalFile

//------------------------------------------------------------------------------
// GET ALL INPUT PARAMETERS
//------------------------------------------------------------------------------
DateParser dateParser = new DateParser()
AirPluginTool apTool = new AirPluginTool(this.args[0], this.args[1])

Properties stepProps = apTool.getStepProperties()

// Repo
String commandPath = stepProps['source/repo/commandPath']
String broker = stepProps['source/repo/broker']
String username = stepProps['source/repo/username']
String password = stepProps['source/repo/password'] ?: stepProps['source/repo/passScript']

// Source
File dir = new File(workDir, stepProps['source/dirOffset'] ?: '.').canonicalFile //log file directory
String pkg = stepProps['source/package']
String project = stepProps['source/project']
String viewPath = stepProps['source/viewPath']
String state = stepProps['source/state']
String userExcludesString = stepProps['source/excludeUsers'] ?: ''
String fileFiltersString  = stepProps['source/fileFilters'] ?: ''
String includeFiles = stepProps['source/includeFiles']

// Step
Date startDate = dateParser.parseDate(stepProps['startDate'])
Date endDate = dateParser.parseDate(stepProps['endDate'])
String changesUrl = stepProps['changesUrl']

//
// Perform step
//
dir.mkdirs()

SCMChangelog step = new SCMChangelog()
step.directory = dir
step.commandPath = commandPath
step.scmCmd = 'hsv'
step.broker = broker
step.username = username
step.password = password
step.project = project
step.viewPath = viewPath
step.state = state
step.pkg = pkg
step.startDate = startDate
step.endDate = endDate
step.includeFiles = includeFiles?.tokenize("\n") as String[]

step.changesUrl = changesUrl.trim()
step.changeSetFilter.setUserExcludes(userExcludesString)
step.changeSetFilter.setFileFilters(fileFiltersString)
step.executeChangelog()