/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
package com.urbancode.air.plugin.test.junit

import com.urbancode.ubuild.ucbtool.UCBTool;
import java.io.*;
import java.nio.file.*;

public class XMLHelper {

    //**************************************************************************
    // CLASS
    //**************************************************************************
    private static String NO_SUITE_NAME = "Unnamed";

    //**************************************************************************
    // INSTANCE
    //**************************************************************************
    private int testCount = 0;
    private int suiteCount = 0;

    private Integer requestTimeout = -1;

    public XMLHelper() {
    }

    def uploadResult (reportFiles, reportName, truncate) {
        def testsuiteName;
        def xml;
        def result;
        def name;
        def time;
        int totalTime;
        testCount = 0;
        suiteCount = 0;

        long startTotalTime = System.currentTimeMillis();
        def reportXml = new groovy.xml.StreamingMarkupBuilder().bind {
            "test-report"("name":reportName,
            "type": 'JUnit',
            "job-id": System.getenv('JOB_ID')) {
                reportFiles.each {
                    xml = it;
                    def rootNode = new XmlSlurper().parse(xml);
                    def testSuites = [];
                    def index = 0;
                    if (rootNode.name().equals("testsuite")) {
                        testSuites[index] = rootNode;
                        index++;
                    }
                    else {
                        rootNode.testsuite.each { testsuite ->
                            testSuites[index] = testsuite;
                            index++;
                        }
                    }

                    testSuites.each { testsuite ->
                        suiteCount++;
                        if (testsuite.@name) {
                            if (truncate) {
                                testsuiteName = testsuite.@name.text().substring(testsuite.@name.text().lastIndexOf('.') + 1);
                            }
                            else {
                                testsuiteName = testsuite.@name.text();
                            }
                        }
                        else {
                            testsuiteName = NO_SUITE_NAME;
                        }

                        "test-suite"("name": testsuiteName) {
                            testsuite.testcase.each { testcase ->
                                testCount++;
                                if (!testcase.failure && !testcase.error) {
                                    result = 'success';
                                }
                                else {
                                    result = 'failure';
                                }
                                if (testcase.@classname){
                                    name = testcase.@classname.text() + ' ' + testcase.@name.text();
                                }
                                else {
                                    name = testcase.@name.text();
                                }

                                time = testcase.@time.text();
                                if (!time) {
                                    time = "0";
                                }
                                time = time.replaceAll(',', '');
                                time = (int) (Double.parseDouble(time) * 1000);
                                "test" ("name": name, "result": result ,"time": time) {
                                    if (result == 'failure') {
                                        def errorMsg = "";
                                        testcase.error.each { error -> errorMsg += 'Error Message: ' + error.@message.text() + ' Error Text: ' + error.text(); }
                                        testcase.failure.each { error -> errorMsg += 'Error Message: ' + error.@message.text() + ' Error Text: ' + error.text(); }
                                        "message"(errorMsg);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        long endTotalTime = System.currentTimeMillis();
        totalTime = endTotalTime - startTotalTime;

        if (reportXml) {
            println "Total time taken to collect test cases : " + totalTime;
            sendPostRequest(reportName, reportXml.toString())
        }
        else {
            println 'No report was able to be generated';
        }
    }

    public void setRequestTimeout(Integer requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    private void sendPostRequest(String name, String xml) {
        def descString = "Sending ${testCount} test results from ${suiteCount} test suites";
        UCBTool ucbTool = new UCBTool();
        if (requestTimeout > 0) {
            ucbTool.setRequestTimeout(requestTimeout);
        }
        def buildLifeId = System.getenv("BUILD_LIFE_ID");
        def baseUrl = System.getenv("WEB_URL");
        def authToken = System.getenv("AUTH_TOKEN");
        ucbTool.addTestReports(baseUrl, authToken, buildLifeId, name, xml, descString);
    }
}