/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.concurrent.deferred;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.concurrent.deferred.Deferred;
import com.urbancode.commons.util.concurrent.deferred.Rejected;
import com.urbancode.commons.util.concurrent.deferred.Resolved;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
public class BasicDeferred<T>
implements Deferred<T> {
    private final ReentrantLock lock = new ReentrantLock();
    private List<Object> actions;
    private volatile Value<?> value;

    @Override
    public boolean resolve(T value) {
        return this.setResolved(value);
    }

    @Override
    public boolean reject(Throwable cause) {
        return this.setRejected(cause);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.setCancelled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Deferred<T> then(Resolved<? super T> action) {
        block8: {
            if (action != null) {
                this.lock.lock();
                try {
                    if (!this.isDone()) {
                        this.add(action);
                        break block8;
                    }
                    if (!this.isResolved()) break block8;
                    Resolution value = (Resolution)this.value;
                    this.beforeAction(action);
                    try {
                        action.run(value.get());
                    }
                    finally {
                        this.afterAction(action);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
        return this;
    }

    @Override
    public Deferred<T> then(Executor executor, Resolved<? super T> action) {
        if (action != null) {
            if (executor != null) {
                this.then(new ExecutorResolved<T>(executor, action));
            } else {
                this.then(action);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Deferred<T> fail(Rejected action) {
        block8: {
            if (action != null) {
                this.lock.lock();
                try {
                    if (!this.isDone()) {
                        this.add(action);
                        break block8;
                    }
                    if (!this.isRejected()) break block8;
                    Rejection value = (Rejection)this.value;
                    this.beforeAction(action);
                    try {
                        action.run(value.get());
                    }
                    finally {
                        this.afterAction(action);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
        return this;
    }

    @Override
    public Deferred<T> fail(Executor executor, Rejected action) {
        if (action != null) {
            if (executor != null) {
                this.fail(new ExecutorRejected(executor, action));
            } else {
                this.fail(action);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Deferred<T> always(Runnable action) {
        block8: {
            if (action != null) {
                this.lock.lock();
                try {
                    if (!this.isDone()) {
                        this.add(action);
                        break block8;
                    }
                    if (this.isCancelled()) break block8;
                    this.beforeAction(action);
                    try {
                        action.run();
                    }
                    finally {
                        this.afterAction(action);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
        return this;
    }

    @Override
    public Deferred<T> always(Executor executor, Runnable action) {
        if (action != null) {
            if (executor != null) {
                this.always(new ExecutorRunnable(executor, action));
            } else {
                this.always(action);
            }
        }
        return this;
    }

    @Override
    public final boolean isDone() {
        return this.value != null;
    }

    @Override
    public final boolean isResolved() {
        return this.value instanceof Resolution;
    }

    @Override
    public final boolean isRejected() {
        return this.value instanceof Rejection;
    }

    @Override
    public final boolean isCancelled() {
        return this.value instanceof Cancellation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean setResolved(T value) {
        boolean resolved = false;
        this.lock.lock();
        try {
            if (!this.isDone()) {
                this.value = new Resolution(value);
                resolved = true;
                this.runResolveActions(this.clearActions(), value);
            }
        }
        finally {
            this.lock.unlock();
        }
        return resolved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean setRejected(Throwable cause) {
        boolean rejected = false;
        this.lock.lock();
        try {
            if (!this.isDone()) {
                this.value = new Rejection(cause);
                rejected = true;
                this.runRejectActions(this.clearActions(), cause);
            }
        }
        finally {
            this.lock.unlock();
        }
        return rejected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean setCancelled() {
        boolean cancelled = false;
        this.lock.lock();
        try {
            if (!this.isDone()) {
                this.value = new Cancellation();
                cancelled = true;
                this.clearActions();
            }
        }
        finally {
            this.lock.unlock();
        }
        return cancelled;
    }

    protected void beforeAction(Object action) {
    }

    protected void afterAction(Object action) {
    }

    private void add(Object action) {
        assert (action instanceof Resolved || action instanceof Rejected || action instanceof Runnable);
        assert (this.lock.isHeldByCurrentThread());
        assert (!this.isDone());
        if (this.actions == null) {
            this.actions = new ArrayList<Object>();
        }
        this.actions.add(action);
    }

    private List<Object> clearActions() {
        assert (this.lock.isHeldByCurrentThread());
        List<Object> result = this.actions;
        this.actions = null;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runResolveActions(List<Object> actions, T result) {
        assert (this.lock.isHeldByCurrentThread());
        if (actions != null) {
            for (Object action : actions) {
                assert (action != null);
                this.beforeAction(action);
                try {
                    if (action instanceof Resolved) {
                        ((Resolved)action).run(result);
                        continue;
                    }
                    if (!(action instanceof Runnable)) continue;
                    ((Runnable)action).run();
                }
                finally {
                    this.afterAction(action);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runRejectActions(List<Object> actions, Throwable cause) {
        assert (this.lock.isHeldByCurrentThread());
        if (actions != null) {
            for (Object action : actions) {
                assert (action != null);
                this.beforeAction(action);
                try {
                    if (action instanceof Rejected) {
                        ((Rejected)action).run(cause);
                        continue;
                    }
                    if (!(action instanceof Runnable)) continue;
                    ((Runnable)action).run();
                }
                finally {
                    this.afterAction(action);
                }
            }
        }
    }

    @BridgeMethodsAdded
    private static final class ExecutorRunnable
    implements Runnable {
        final Executor executor;
        final Runnable action;

        ExecutorRunnable(Executor executor, Runnable action) {
            this.executor = executor;
            this.action = action;
        }

        public void run() {
            this.executor.execute(this.action);
        }
    }

    @BridgeMethodsAdded
    private static final class ExecutorRejected
    implements Rejected,
    Runnable {
        final Executor executor;
        final Rejected action;
        Throwable cause;

        ExecutorRejected(Executor executor, Rejected action) {
            this.executor = executor;
            this.action = action;
        }

        public void run(Throwable cause) {
            this.cause = cause;
            this.executor.execute(this);
        }

        public void run() {
            this.action.run(this.cause);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @BridgeMethodsAdded
    private static final class ExecutorResolved<T>
    implements Resolved<T>,
    Runnable {
        final Executor executor;
        final Resolved<? super T> action;
        T result;

        ExecutorResolved(Executor executor, Resolved<? super T> action) {
            this.executor = executor;
            this.action = action;
        }

        @Override
        public void run(T result) {
            this.result = result;
            this.executor.execute(this);
        }

        @Override
        public void run() {
            this.action.run(this.result);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @BridgeMethodsAdded
    private static final class Cancellation
    extends Value<Void> {
        Cancellation() {
        }

        @Override
        Void get() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @BridgeMethodsAdded
    private static final class Rejection
    extends Value<Throwable> {
        final Throwable cause;

        Rejection(Throwable cause) {
            this.cause = cause;
        }

        @Override
        Throwable get() {
            return this.cause;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @BridgeMethodsAdded
    private static final class Resolution<T>
    extends Value<T> {
        final T value;

        Resolution(T value) {
            this.value = value;
        }

        @Override
        T get() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @BridgeMethodsAdded
    private static abstract class Value<T> {
        private Value() {
        }

        abstract T get();
    }
}

