/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.*
import com.urbancode.air.plugin.test.junit.FileSet
import com.urbancode.air.plugin.test.junit.XMLHelper

def apTool = new AirPluginTool(this.args[0], this.args[1])

//------------------------------------------------------------------------------
// PARSE PROPERTIES
//------------------------------------------------------------------------------

Properties props = apTool.getStepProperties()

String reportName = props['reportName'] ?: 'JUnit Report'
File sourceDir = new File(props['sourceDir'])
String includes = props['includes']
String excludes = props['excludes']
String truncate = props['truncate']
String requestTimeoutStr = props['requestTimeout']
Integer requestTimeout = -1
if (requestTimeoutStr) {
    requestTimeout = Integer.valueOf(requestTimeoutStr, 10)
}
//------------------------------------------------------------------------------
// EXECUTE
//------------------------------------------------------------------------------
try {
    FileSet fileSet = new FileSet(sourceDir)
    fileSet.include(includes)
    fileSet.exclude(excludes)

    List reportFiles = fileSet.files()
    println 'Base Directory: ' + sourceDir.getAbsolutePath()
    println 'Include File Patterns: ' + includes
    println 'Exclude File Patterns: ' + excludes

    reportFiles.each { file ->
        println 'Report File identified to be included in the JUnit Report: ' + file
    }

    if (reportFiles.size() > 0) {
        XMLHelper xmlHelper = new XMLHelper()
        if (requestTimeout > 0) {
            xmlHelper.setRequestTimeout(requestTimeout)
        }
        xmlHelper.uploadResult(reportFiles, reportName, truncate)
    }
    else {
        println 'No report files found to upload'
    }
}
catch (e) {
    println e
    System.exit 1
}