package com.urbancode.air.plugin.quality.jacoco

import org.apache.commons.httpclient.HttpClient
import org.apache.commons.httpclient.methods.PostMethod
import org.apache.commons.httpclient.methods.StringRequestEntity
import org.apache.commons.httpclient.protocol.Protocol
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory

import com.urbancode.commons.util.IO
import com.urbancode.commons.util.https.OpenSSLProtocolSocketFactory

public class JacocoCoverageXMLHelper {
    
    //**************************************************************************
    // CLASS
    //**************************************************************************

    //**************************************************************************
    // INSTANCE
    //**************************************************************************
    private def testCount = 0
    private def suiteCount = 0
    
    public JacocoCoverageXMLHelper() {
    }
    
    def uploadResult (reportName, buildLifeId, coverageXmlFile) {
        def testsuiteName
        def xml
        def result
        def name
        def time
        testCount = 0
        suiteCount = 0

        XmlParser parser = new XmlParser()
        parser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        parser.setFeature("http://xml.org/sax/features/namespaces", false)
        def rootNode = parser.parse(coverageXmlFile)
        
        def reportXml = new java.io.StringWriter()
        new groovy.xml.MarkupBuilder(reportXml).
            "coverage-report"(
                "name": reportName,
                "type": 'JaCoCo',
                "build-life-id": buildLifeId,
                "line-percentage": getValue(rootNode."counter".find{it.@"type" == "LINE"}),
                "method-percentage": getValue(rootNode."counter".find{it.@"type" == "METHOD"}),
                "branch-percentage": getValue(rootNode."counter".find{it.@"type" == "BRANCH"}),
                "complexity": getValue(rootNode."counter".find{it.@"type" == "COMPLEXITY"})
            ) {
            rootNode."package".each { packageNode ->
                "coverage-group"(
                    "name": packageNode.@name,
                    "line-percentage": getValue(packageNode."counter".find{it.@"type" == "LINE"}),
                    "method-percentage": getValue(packageNode."counter".find{it.@"type" == "METHOD"}),
                    "branch-percentage": getValue(packageNode."counter".find{it.@"type" == "BRANCH"}),
                    "complexity": getValue(packageNode."counter".find{it.@"type" == "COMPLEXITY"})
                )
            }
        }
            
        if (reportXml) {
            //println "Sending report:\n" + reportXml.toString()
            sendPostRequest(reportName, reportXml.toString())
        }
        else {
            println 'No report was able to be generated'
        }
    }
    
    private def getValue(def counter) {
        int missed = 0;
        int covered = 0;
    
        if (counter) {
            if (counter.@"missed") {
                missed = Integer.parseInt(counter.@"missed") 
            }
            
            if (counter.@"covered") {
                covered = Integer.parseInt(counter.@"covered")
            }
        }
        
        int total = missed + covered
        return (double) covered / (total ?: 1)
    }
    
    private void sendPostRequest(String name, String xml) {
        def authToken = System.getenv("AUTH_TOKEN")
        String buildLifeId = System.getenv("BUILD_LIFE_ID")
        def reportName = URLEncoder.encode(name)
        
        // construct the URL with property replacements
        String baseUrl = System.getenv("WEB_URL")
        
        baseUrl += baseUrl.endsWith("/") ? "" : "/"
        String url = baseUrl + "rest/buildlife/${buildLifeId}/testcoverage?reportName=${reportName}"
        
        println "Sending request to $url"

        ProtocolSocketFactory socketFactory = new OpenSSLProtocolSocketFactory()
        Protocol https = new Protocol("https", socketFactory, 443)
        Protocol.registerProtocol("https", https)

        PostMethod postMethod = new PostMethod(url)
        if (authToken) {
            postMethod.setRequestHeader("Authorization-Token", authToken)
            postMethod.setRequestHeader("Content-Type", "application/xml")
        }
        
        println "Sending coverage report"
        postMethod.setRequestEntity(new StringRequestEntity(xml));

        HttpClient client = new HttpClient()

        def responseCode = client.executeMethod(postMethod)
        InputStream responseStream = postMethod.getResponseBodyAsStream()
        if (isGoodResponseCode(responseCode)) {
            IO.copy(responseStream, System.out)
            println ""
        }
        else {
            IO.copy(responseStream, System.err)
            throw new RuntimeException("Failed to upload JaCoCo coverage report. StatusCode: ${responseCode}")
        }
    }
    
    private boolean isGoodResponseCode(int responseCode) {
        return responseCode >= 200 && responseCode < 300;
    }
}