import com.urbancode.air.*
import com.urbancode.air.plugin.quality.jacoco.JacocoCoverageXMLHelper

def apTool = new AirPluginTool(this.args[0], this.args[1])

//------------------------------------------------------------------------------
// PARSE PROPERTIES
//------------------------------------------------------------------------------

def props = apTool.getStepProperties()

final def reportName   = props['reportName'] ?: 'JaCoCo Report'
final def jacocoOutputDirectory = new File(props['jacocoOutputDirectory'] ?: '.')
final def buildLifeId = System.getenv('BUILD_LIFE_ID')

//------------------------------------------------------------------------------
// EXECUTE
//------------------------------------------------------------------------------

try {
    def coverageXmlFile = new File(jacocoOutputDirectory, "jacoco.xml").canonicalFile
    
    if (coverageXmlFile.exists() && coverageXmlFile.isFile()) {
        println 'jacoco.xml found: ' + coverageXmlFile.absolutePath
        def xmlHelper = new JacocoCoverageXMLHelper()
        xmlHelper.uploadResult(reportName, buildLifeId, coverageXmlFile)
    }
    else {
        println 'jacoco.xml NOT found: ' + coverageXmlFile.absolutePath
    }
}
catch (e) {
    e.printStackTrace()
    System.exit 1
}
