/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.ssl;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.ssl.SSLSocketConfig;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

@BridgeMethodsAdded
class ConfigurableSSLSocketFactory
extends SSLSocketFactory {
    final SSLSocketFactory socketFactory;
    List<SSLSocketConfig> configurators = new ArrayList<SSLSocketConfig>();

    public ConfigurableSSLSocketFactory(SSLSocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public synchronized void addSocketConfigurator(SSLSocketConfig config) {
        this.configurators.add(config);
    }

    protected synchronized void configure(SSLSocket socket) {
        for (SSLSocketConfig config : this.configurators) {
            config.configure(socket);
        }
    }

    public String[] getDefaultCipherSuites() {
        return this.socketFactory.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        return this.socketFactory.getSupportedCipherSuites();
    }

    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        SSLSocket socket = (SSLSocket)this.socketFactory.createSocket(s, host, port, autoClose);
        this.configure(socket);
        return socket;
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        SSLSocket socket = (SSLSocket)this.socketFactory.createSocket(host, port);
        this.configure(socket);
        return socket;
    }

    public Socket createSocket(InetAddress host, int port) throws IOException {
        SSLSocket socket = (SSLSocket)this.socketFactory.createSocket(host, port);
        this.configure(socket);
        return socket;
    }

    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        SSLSocket socket = (SSLSocket)this.socketFactory.createSocket(host, port, localHost, localPort);
        this.configure(socket);
        return socket;
    }

    public Socket createSocket(InetAddress host, int port, InetAddress localAddress, int localPort) throws IOException {
        SSLSocket socket = (SSLSocket)this.socketFactory.createSocket(host, port, localAddress, localPort);
        this.configure(socket);
        return socket;
    }
}

