package com.urbancode.air.plugin.quality.jacoco

public class CoverageReport {
    String reportName
    def buildLifeId
    Map coverageGroups = new HashMap<String, CoverageGroup>()

    CoverageGroup totals = new CoverageGroup()

    public CoverageReport(String reportName, String buildLifeId) {
        this.reportName = reportName
        this.buildLifeId = buildLifeId
    }

    public def generateReportXml() {
        def reportXml = new java.io.StringWriter()
        new groovy.xml.MarkupBuilder(reportXml).
            "coverage-report"(
                    "name": reportName,
                    "type": 'JaCoCo',
                    "build-life-id": buildLifeId,
                    "line-percentage": totals.lineCounts.getPercentCoverage(),
                    "method-percentage": totals.methodCounts.getPercentCoverage(),
                    "branch-percentage": totals.branchCounts.getPercentCoverage(),
                    "complexity": totals.complexityCounts.getPercentCoverage()

            ) {

            coverageGroups.each { String name, CoverageGroup group ->
                "coverage-group"(
                        "name": name,
                        "line-percentage": group.lineCounts.getPercentCoverage(),
                        "method-percentage": group.methodCounts.getPercentCoverage(),
                        "branch-percentage": group.branchCounts.getPercentCoverage(),
                        "complexity": group.complexityCounts.getPercentCoverage()
                )
            }
        }
        return reportXml
    }
}
