/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.*
import com.urbancode.air.plugin.quality.jacoco.JacocoCoverageXMLHelper

def apTool = new AirPluginTool(this.args[0], this.args[1])

//------------------------------------------------------------------------------
// PARSE PROPERTIES
//------------------------------------------------------------------------------

def props = apTool.getStepProperties()

final def reportName        = props['reportName'] ?: 'JaCoCo Report'
final def jacocoBaseDir     = new File(props['jacocoOutputDirectory'])
final def includes          = props['includes']
final def excludes          = props['excludes']
final def buildLifeId       = System.getenv('BUILD_LIFE_ID')

//------------------------------------------------------------------------------
// EXECUTE
//------------------------------------------------------------------------------

try {
    def fileSet = new FileSet(jacocoBaseDir)
    fileSet.include(includes)
    fileSet.exclude(excludes)

    def reportFiles = fileSet.files()
    println 'Base Directory: ' +  jacocoBaseDir.getAbsolutePath()
    println 'Include File Patterns: ' + includes
    println 'Exclude File Patterns: ' + excludes

    reportFiles.each { file->
        println 'Report File identified to be included in the JaCoCo Report: ' + file
    }

    if (reportFiles.size() > 0) {
        def xmlHelper = new JacocoCoverageXMLHelper()
        xmlHelper.uploadResult(reportFiles, reportName, buildLifeId)
    }
    else {
        println 'No report files found to upload'
    }
}
catch (e) {
    e.printStackTrace()
    System.exit 1
}
