package com.urbancode.air.plugn.test.mstest
import org.xml.sax.Attributes
import org.xml.sax.InputSource
import org.xml.sax.SAXException
import org.xml.sax.helpers.DefaultHandler

class SuiteHandler extends DefaultHandler {
    def filename
    def suiteName

    SuiteHandler(filename) {
        this.filename = filename
    }

    void startElement(String ns, String localName, String qName, Attributes attrs) {
        if (qName == 'TestRunConfiguration') {
        suiteName = attrs.getValue('name')
         throw new EndParseEarlyException()
        }
    }

    def getSuiteName() {
        def reader = SAXParserFactory.newInstance().newSAXParser().XMLReader
        try {
         def suiteFile = (filename instanceof File) ? filename : new File(filename)
         suiteFile.withInputStream { stream ->
             reader.setContentHandler(this)
             reader.parse(new InputSource(stream))
         }
        }
        catch (EndParseEarlyException swallow) {
        }
        return suiteName
    }
}

class EndParseEarlyException extends SAXException {}