import com.urbancode.air.*
import com.urbancode.air.plugin.test.junit.FileSet
import com.urbancode.air.plugin.test.junit.XMLHelper

def apTool = new AirPluginTool(this.args[0], this.args[1])

//------------------------------------------------------------------------------
// PARSE PROPERTIES
//------------------------------------------------------------------------------

def props = apTool.getStepProperties()

final def reportName        = props['reportName'] ? props['reportName'] : 'MSTest Report'
final def baseDir           = new File(props['baseDir'])
final def includes          = props['includes']
final def excludes          = props['excludes']

//------------------------------------------------------------------------------
// EXECUTE
//------------------------------------------------------------------------------

try {
    def fileSet = new FileSet(baseDir)
    fileSet.include(includes)
    fileSet.exclude(excludes)
    
    def reportFiles = fileSet.files()
    println 'Base Directory: ' +  sourceDir.getAbsolutePath()
    println 'Include File Patterns: ' + includes
    println 'Exclude File Patterns: ' + excludes
    
    reportFiles.each { file->
        println 'Report File identified to be included in the JUnit Report: ' + file
    }
    
    if (reportFiles.size() > 0) {
        def xmlHelper = new XMLHelper()
        xmlHelper.uploadResult(reportFiles, reportName)
    }
    else {
        println 'No report files found to upload'
    }
}
catch (e) {
    println e
    System.exit 1
}
