package com.urbancode.air.plugn.test.mstest
import org.apache.http.HttpResponse
import org.apache.http.client.HttpClient
import org.apache.http.client.methods.HttpPost
import org.apache.http.entity.StringEntity

import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder
import com.urbancode.commons.util.IO

public class XMLHelper {
    
    //**************************************************************************
    // CLASS
    //**************************************************************************

    //**************************************************************************
    // INSTANCE
    //**************************************************************************
    private def testCount = 0
    private def suiteCount = 0
    
    public XMLHelper() {
    }
    
    def uploadResult (reportFiles, reportName) {
        def xml
        testCount = 0
        suiteCount = 0
        
        def reportXml = new java.io.StringWriter()
        
        new groovy.xml.MarkupBuilder(reportXml).
        'test-report'("name": reportName, 
            "type": 'MSTest', 
            "job-id": System.getenv('JOB_ID')) {
                reportFiles.each { file ->
                    println("Parsing " + file.absolutePath)
                    def suiteName = new SuiteHandler(file).getSuiteName()
                    suiteCount++
                    'test-suite'(name: suiteName) {
                        def handler = new MSTestHandler(file)
                        handler.readTests { testName, testClass, testResult, testDuration, messages ->
                            testCount++
                            test("name": testName, 'class-name': testClass, "result": testResult, "time": testDuration) {
                                messages.each {
                                    message(it)
                                }
                            }
                        }
                    }
                }
            }
        
        if (reportXml) {
            sendPostRequest(reportName, reportXml.toString())
        }
        else {
            println 'No report was able to be generated'
        }
    }
    
    private void sendPostRequest(String name, String xml) {
        def authToken = System.getenv("AUTH_TOKEN")
        String buildLifeId = System.getenv("BUILD_LIFE_ID")
        name = encode(name)
        
        // construct the URL with property replacements
        String baseUrl = System.getenv("WEB_URL")
        
        baseUrl += baseUrl.endsWith("/") ? "" : "/"
        String url = baseUrl + "rest/buildlife/${buildLifeId}/tests?reportName=${name}"
        
        println "Sending request to $url"

        HttpPost postMethod = new HttpPost(url)
        if (authToken) {
            postMethod.addHeader("Authorization-Token", authToken)
            postMethod.addHeader("Content-Type", "application/xml")
        }
        
        println "Sending ${testCount} test results from ${suiteCount} test suites"
        postMethod.setEntity(new StringEntity(xml))
        
        HttpClientBuilder builder = new HttpClientBuilder()
        builder.setTrustAllCerts(true)
        HttpClient client = builder.buildClient()
        
        HttpResponse response = client.execute(postMethod)
        def responseCode = response.statusLine.statusCode
        InputStream responseStream = response.entity.content
        if (isGoodResponseCode(responseCode)) {
            IO.copy(responseStream, System.out)
            println ""
        }
        else {
            IO.copy(responseStream, System.err)
            throw new RuntimeException("Failed to upload JUnit test results. StatusCode: ${responseCode}")
        }
    }
    
    private boolean isGoodResponseCode(int responseCode) {
        return responseCode >= 200 && responseCode < 300;
    }
    
    private def encode = {
        return !it ? it : new java.net.URI(null, null, it, null).toASCIIString()
    }
}