/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
package com.urbancode.air.plugin.test.mstest
import org.xml.sax.Attributes
import org.xml.sax.InputSource
import org.xml.sax.SAXException
import org.xml.sax.helpers.DefaultHandler
import javax.xml.parsers.SAXParserFactory

class SuiteHandler extends DefaultHandler {
    def filename
    def suiteName

    SuiteHandler(filename) {
        this.filename = filename
    }

    void startElement(String ns, String localName, String qName, Attributes attrs) {
        if (qName == 'TestRunConfiguration') {
            suiteName = attrs.getValue('name')
            throw new EndParseEarlyException()
        }
    }

    def getSuiteName() {
        def reader = SAXParserFactory.newInstance().newSAXParser().XMLReader
        try {
            def suiteFile = (filename instanceof File) ? filename : new File(filename)
            suiteFile.withInputStream { stream ->
                reader.setContentHandler(this)
                reader.parse(new InputSource(stream))
            }
        }
        catch (EndParseEarlyException swallow) {
        }
        return suiteName
    }
}

class EndParseEarlyException extends SAXException {}
