/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.*
import com.urbancode.air.plugin.test.mstest.XMLHelper

//------------------------------------------------------------------------------
// PARSE PROPERTIES
//------------------------------------------------------------------------------

final def apTool = new AirPluginTool(args[0], args[1])
def props = apTool.getStepProperties()

final def reportName        = props['reportName'] ? props['reportName'] : 'MSTest Report'
final def baseDir           = new File(props['baseDir'] ?: '.')
final def includes          = props['includes']
final def excludes          = props['excludes']

//------------------------------------------------------------------------------
// EXECUTE
//------------------------------------------------------------------------------

try {
    def fileSet = new FileSet(baseDir)
    fileSet.include(includes)
    fileSet.exclude(excludes)
    
    def reportFiles = fileSet.files()
    println 'Base Directory: ' +  baseDir.getAbsolutePath()
    println 'Include File Patterns: ' + includes
    println 'Exclude File Patterns: ' + excludes
    
    reportFiles.each { file->
        println 'Report File identified to be included in the JUnit Report: ' + file
    }
    
    if (reportFiles.size() > 0) {
        def xmlHelper = new XMLHelper()
        xmlHelper.uploadResult(reportFiles, reportName)
    }
    else {
        println 'No report files found to upload'
    }
}
catch (e) {
    println e
    System.exit 1
}
