/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.CommandHelper
import com.urbancode.air.AirPluginTool

final def workDir = new File('.').canonicalFile
def ch = new CommandHelper(workDir)
def apTool = new AirPluginTool(this.args[0], this.args[1])
def props = apTool.getStepProperties()

final def makeFileName = props['makeFileName']
final def makeTargets = props['makeTargets']
final def makeArgs = props['makeArgs']
final def envVars = props['envVars']
def commandLineArgs = []

// Build command line
commandLineArgs << "make"
if (makeFileName) {
    commandLineArgs << "-f" << makeFileName
}

if (makeTargets) {
    makeTargets.split("\\s").each() { target ->
        if (target) {
            commandLineArgs << target
        }
    }
}

if (makeArgs) {
    makeArgs.split("\\s").each() { arg ->
        if (arg) {
            commandLineArgs << arg
        }
    }
}

// Set any environment variables on the environment itself
if (envVars) {
    def pb = ch.getProcessBuilder()
    def envProps = pb.environment()
    
    envVars.split('\n').each() { prop ->
        def propMap = prop.split("=", 2)
        envProps[propMap[0]] = propMap[1]
    }
}

ch.runCommand("Running Make command", commandLineArgs)
