package com.urbancode.air.plugin.scm.changelog

public class ChangeSet {

    //**************************************************************************
    // CLASS
    //**************************************************************************

    //**************************************************************************
    // INSTANCE
    //**************************************************************************

    String id= null;
    String user = null;
    String message = null;
    Date date = null;
    final List<ChangeSetFileEntry> fileSet = [];
    Map<String,String> properties = new LinkedHashMap();

    /**
     * Determine if the change contains only excluded file paths.
     * (an empty fileset will be included)
     *
     * @param changeSetFilter
     * @return
     */
    public boolean hasAllowedPath(ChangeSetFilter changeSetFilter) {
        return !fileSet || fileSet.find{ changeSetFilter.pathIsIncluded(it.path) } != null;
    }

    public boolean hasAllowedAuthor(ChangeSetFilter changeSetFilter) {
        return changeSetFilter.authorIsIncluded(user);
    }
}
