/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.*
import com.urbancode.air.plugin.scm.*
import java.text.*


final def dateParser = new DateParser();
final def apTool = new AirPluginTool(args[0], args[1]);

//------------------------------------------------------------------------------
// PARSE PROPERTIES
//------------------------------------------------------------------------------

final def stepProps = apTool.getStepProperties()

final def workDir = new File('.').canonicalFile
final def out = System.out


final def hgCmd            = stepProps["source/repo/commandPath"] ?: 'hg'
final def srcName          = stepProps['source'];
final def dir              = new File(workDir, stepProps['source/dirOffset'] ?: '.').canonicalFile // get checkout directory
final def branch           = stepProps['source/branch'] ?: 'default'

def userExcludesString     = stepProps['source/excludeUsers'] ?: ''
def fileFiltersString      = stepProps['source/fileFilters'] ?: '';

final def startRevision    = stepProps['startRevision'] ?: ''
final def endRevision      = stepProps['endRevision'] ?: ''
final def startDate        = dateParser.parseDate(stepProps['startDate']) // explicit start date ?: startBuildLife.actualWorkspaceDate
final def endDate          = dateParser.parseDate(stepProps['endDate'])   // explicit end date ?: buildLife.actualWorkspaceDate
final def startBuildLifeId = stepProps['startBuildlifeId'] ? stepProps['startBuildlifeId'] as Long : null  // change-log start status (if no explicit startDate)
final String changesUrl    = stepProps['changesUrl']

// Execute
dir.mkdirs()

SCMChangelog changelog = new SCMChangelog();
changelog.hgCmd = hgCmd
changelog.directory = dir
changelog.branch = branch

changelog.startRevision = startRevision
changelog.endRevision = endRevision
changelog.startDate = startDate
changelog.endDate = endDate
changelog.changesUrl = changesUrl

changelog.changeSetFilter.setUserExcludes(userExcludesString);
changelog.changeSetFilter.setFileFilters(fileFiltersString);

changelog.execute()