/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
package com.urbancode.air.plugin.scm

import com.urbancode.air.*
import com.urbancode.air.plugin.scm.changelog.*;

import java.text.*;
import java.util.Date;


public class SCMCheckout {

    //**************************************************************************
    // CLASS
    //**************************************************************************

    static private final SCMHelper hgHelper = new SCMHelper();

    //**************************************************************************
    // INSTANCE
    //**************************************************************************

    def out = System.out;

    String hgCmd = "hg"
    File directory;
    boolean clean = false
    String remoteUrl
    String remoteUser
    String remotePass
    String branch
    String revision
    Date date

    /**
     *
     */
    public void execute() {

        //
        // PREPARE WORKING DIRECTORY
        //
        MercurialWorkspace workspace = new MercurialWorkspace()
        workspace.hgCmd = hgCmd;
        workspace.directory = directory;
        workspace.remoteUrl = remoteUrl;
        workspace.remoteUser = remoteUser;
        workspace.remotePass = remotePass
        workspace.branch = branch;
        workspace.revision = revision;
        if (clean) {
            workspace.delete();
        }
        workspace.init();

        //
        // Execute Mercurial Commands
        //
        final def cmdHelper = new CommandHelper(directory);

        // Determine Revision By Date
        if (!revision && date) {
            def getRevisionCommand = [hgCmd, "log"]
            getRevisionCommand << "--template" << "{node}\n"
            if (branch) {
                getRevisionCommand << "--branch" << branch
            }
            getRevisionCommand << "--date" << "<${hgHelper.dateFormatter.format(date)}"
            getRevisionCommand << "--limit" << "1"

            cmdHelper.runCommand('Get Mercurial Revision Id for date', getRevisionCommand){ proc ->
                proc.consumeProcessErrorStream(out)
                proc.outputStream.close() // close stdin
                revision = proc.text.trim()
                println revision
            }
        }

        // update workspace to specified revision
        def updateCommand = [hgCmd, 'update']
        updateCommand << '--clean'
        if (revision) {
            updateCommand << '--rev' << revision
        }
        else {
            println "No revision specified for checkout"
        }
        cmdHelper.runCommand('Mercurial Update', updateCommand)

        // transform into canonical revision
        if (!(revision ==~ /[a-z0-9]{40}/)) {
            def getCurRev = [hgCmd, 'identify', '--id']
            cmdHelper.runCommand('Get Mercurial Canonical Revision Id', getCurRev) { proc ->
                proc.consumeProcessErrorStream(out)
                proc.out.close() // close stdin
                revision = proc.text.trim()
                println revision
            }
        }
    }
}