/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.*
import com.urbancode.air.plugin.scm.*

final def workDir = new File('.').canonicalFile

final def apTool = new AirPluginTool(args[0], args[1]);
final SCMHelper hgHelper = new SCMHelper();
final def stepProps = apTool.getStepProperties();

final def hgCmd        = stepProps['source/repo/commandPath'] ?: 'hg'
final def dir          = new File(workDir, stepProps['source/dirOffset'] ?: '.').canonicalFile // get checkout directory
final def srcName      = stepProps['source'];
final def remoteUrl    = stepProps['source/remoteUrl']
final def repoBaseUrl  = stepProps['source/repo/repoBaseUrl']
final def remoteUser   = stepProps['source/repo/username']
final def remotePass   = stepProps['source/repo/password'] ?: stepProps['source/repo/passScript']
final def createTag    = stepProps['label']
final def message      = stepProps['message']
final def doPush       = !!(stepProps['doPush'] as Boolean)

final def revision = stepProps["buildlife/workspace.revision.$srcName"]

//------------------------------------------------------------------------------
// PREPARE COMMAND LINE
//------------------------------------------------------------------------------
dir.mkdirs()

SCMTag tag = new SCMTag();
tag.hgCmd = hgCmd
tag.directory = dir
tag.remoteUrl = hgHelper.calculateRepositoryUrl(repoBaseUrl, remoteUrl)
tag.remoteUser = remoteUser
tag.remotePass = remotePass
tag.revision = revision
tag.tagName = createTag
tag.message = message
tag.doPush = doPush
tag.execute()