/*
* Licensed Materials - Property of HCL*
* UrbanCode Build
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.CommandHelper

AirPluginTool apTool = new AirPluginTool(args[0], args[1])

Properties props = apTool.getStepProperties()

String mochaHomeStr = props['mochaHome']
String sourceDir = props['sourceDir']
String resultFile = props['resultFile']
String reporter = props['reporter']
String mochaExecutable = null

final File workDir = new File('.').canonicalFile

// ensure work-dir exists
workDir.mkdirs()

CommandHelper ch = new CommandHelper(workDir)

String mochaExeFileName = null
if (apTool.isWindows) {
    println "[INFO] Operating system is Windows. Setting Mocha executable name to 'mocha.cmd'"
    mochaExeFileName = "mocha.cmd"
}
else {
    println "[INFO] Setting Mocha executable name to 'mocha'"
    mochaExeFileName = "mocha"
}

if (mochaHomeStr) {
    println "[INFO] Mocha home plugin step field has been set to: $mochaHomeStr"
    mochaExecutable = new File(mochaHomeStr, mochaExeFileName).getAbsolutePath()
}
else {
    println "[INFO] Mocha home plugin step field has not been set. Expecting the mocha executable to be in PATH."
    mochaExecutable = mochaExeFileName
}

println "[INFO] Determined Mocha executable to be: $mochaExecutable"

def runCommandLine = [mochaExecutable]
runCommandLine << sourceDir
runCommandLine << "--reporter"
runCommandLine << reporter

// If Mocha gets to test execution, then the process returns the number of failed tests as the exit code
// Therefore we need to distinguish between a non-zero return code due to other reasons, vs. a non-zero exit code
// due to failed tests.
ch.ignoreExitValue(true)
boolean testsExecuted = false

int exitCode = ch.runCommand("Run Mocha unit tests", runCommandLine) { Process proc ->
    proc.out.close()
    StringBuilder sb = new StringBuilder()
    try {
        proc.waitForProcessOutput(sb, System.out)
    }
    finally {
        System.out.flush()
    }
    if (sb.size() > 0) {
        testsExecuted = true
        File result = new File(resultFile)
        result << sb.toString()
    }
}

println ""
if (testsExecuted) {
    println "Number of failed tests: $exitCode"
}
else if (exitCode != 0) {
    println "Failed to execute tests! Exit code: $exitCode"
}

System.exit(exitCode)