/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.CommandHelper
import com.urbancode.air.AirPluginTool

final def workDir = new File('.').canonicalFile
def ch = new CommandHelper(workDir)
def apTool = new AirPluginTool(this.args[0], this.args[1])
def props = apTool.getStepProperties()

final def nantFile = props['nantFile']
final def targets = props['targets']
final def nantProps = props['properties']
final def nantHome = props['nantHome']
final def monoHome = props['monoHome']
final def cmdProps = props['cmdProps']
final def envVars = props['envVars']
final def scriptContent = props['scriptContent']

def commandLineArgs = []
if (!nantFile) {
    throw new IllegalArgumentException("No NAnt file was specified.")
}

if (!nantHome) {
    throw new IllegalArgumentException("NANT_HOME was not specified")
}

final def nantScriptFile = new File(workDir, nantFile)

// Check if script content was specified, if so, we need to write out the file
boolean deleteOnExit = false
if (scriptContent) {
    if (nantScriptFile.exists()) {
        throw new IllegalArgumentException("A file by the name of " + nantFile + " already exists")
    }
    
    nantScriptFile.text = scriptContent
    deleteOnExit = true
}

def exePath = nantHome

if (!exePath.endsWith("bin") && !exePath.endsWith("bin" + File.separatorChar)) {
    exePath += File.separatorChar
    exePath += "bin"
}

exePath += File.separatorChar
exePath += "nant"

try {
    commandLineArgs << exePath
    
    if (nantProps) {
        nantProps.split("\\s").each() { prop ->
            if (prop) {
                commandLineArgs << prop
            }
        }
    }
    
    if (targets) {
        targets.split("\\s").each() { target ->
            if (target) {
                commandLineArgs << target
            }
        }
    }
    
    if (cmdProps) {
        cmdProps.split("\\s").each() { prop ->
            if (prop) {
                commandLineArgs << prop
            }
        }
    }
    
    commandLineArgs << "-buildfile:" + nantFile
    
    // Set any environment variables on the environment itself
    def pb = ch.getProcessBuilder()
    def envProps = pb.environment()
    envProps["NANT_HOME"] = nantHome
    envProps["MONO_HOME"] = monoHome
    if (envVars) {
        envVars.split('\n').each() { prop ->
            def propMap = prop.split("=", 2)
            envProps[propMap[0]] = propMap[1]
        }
    }
    
    ch.runCommand("Running NAnt command", commandLineArgs)
}
finally {
    if (deleteOnExit) {
        nantScriptFile.delete()
    }
}