/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2017. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.CommandHelper

def apTool = new AirPluginTool(this.args[0], this.args[1])
Properties props = apTool.getStepProperties()
final File workDir = new File('.').canonicalFile
CommandHelper ch = new CommandHelper(workDir)

String NPMExecutable = props['NPMExecutable'] ?: "npm"
String subCommand = props['subCommand']
String args = props['args']

if (subCommand == "set" || subCommand == "get" || subCommand == "delete") {
    if (!args) {
        throw new IllegalArgumentException("No argument has been specified for sub-command $subCommand")
    }
    args.eachLine { arg ->
        List<String> configCommandLine = [NPMExecutable, "config"]
        // this is for <key> <value> arg lines for npm config set <key> <value>
        String[] splittedArg = arg.split(" ")
        configCommandLine << subCommand
        configCommandLine << splittedArg[0]
        if (splittedArg.size() > 1) {
            configCommandLine << splittedArg[1]
        }
        ch.runCommand("Executing 'npm config $subCommand' for argument '$arg'", configCommandLine)
    }
}
else {
    // npm config list
    List<String> configCommandLine = [NPMExecutable, "config"]
    configCommandLine << subCommand
    ch.runCommand(null, configCommandLine)
}

//write the output properties to the file
apTool.storeOutputProperties()