/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2017. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.CommandHelper

def apTool = new AirPluginTool(this.args[0], this.args[1])
def props = apTool.getStepProperties()
final def workDir = new File('.').canonicalFile
def ch = new CommandHelper(workDir)

def NPMExecutable = props['NPMExecutable'] ?: "npm"
def packageArg = props['package']
def tag = props['tag']
def access = props['access']
def publishCommandLine = [NPMExecutable, "publish"]

if (packageArg) {
    publishCommandLine << packageArg
}

if (tag) {
    publishCommandLine << "--tag"
    publishCommandLine << tag
}

if (access) {
    publishCommandLine << "--access"
    publishCommandLine << access
}
ch.runCommand("Publish a package", publishCommandLine)

//write the output properties to the file
apTool.storeOutputProperties()