/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2017. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.CommandHelper

def apTool = new AirPluginTool(this.args[0], this.args[1])
Properties props = apTool.getStepProperties()
final File workDir = new File('.').canonicalFile
CommandHelper ch = new CommandHelper(workDir)

String NPMExecutable = props['NPMExecutable'] ?: "npm"
String args = props['args']
List<String> updateCommandLine = [NPMExecutable, "update"]

if (args) {
    Collections.addAll(updateCommandLine, args.split(/\s+/))
}
ch.runCommand(null, updateCommandLine)

//write the output properties to the file
apTool.storeOutputProperties()