/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool
import com.urbancode.air.FileSet
import com.urbancode.air.plugin.nunit.XMLHelper

def apTool = new AirPluginTool(this.args[0], this.args[1])

//------------------------------------------------------------------------------
// PARSE PROPERTIES
//------------------------------------------------------------------------------

def props = apTool.getStepProperties()

final def reportName        = props['reportName'] ? props['reportName'] : 'NUnit Report'
final def sourceDir         = new File(props['sourceDir'])
final def includes          = props['includes']
final def excludes          = props['excludes']
final def truncate          = props['truncate']

//------------------------------------------------------------------------------
// EXECUTE
//------------------------------------------------------------------------------

try {
    def fileSet = new FileSet(sourceDir)
    fileSet.include(includes)
    fileSet.exclude(excludes)
    
    def reportFiles = fileSet.files()
    println 'Base Directory: ' +  sourceDir.getAbsolutePath()
    println 'Include File Patterns: ' + includes
    println 'Exclude File Patterns: ' + excludes
    
    reportFiles.each { file->
        println 'Report File identified to be included in the NUnit Report: ' + file
    }
    
    if (reportFiles.size() > 0) {
        def xmlHelper = new XMLHelper()
        xmlHelper.uploadResult(reportFiles, reportName, truncate)
    }
    else {
        println 'No report files found to upload'
    }
}
catch (e) {
    println e
    System.exit 1
}
