package com.urbancode.air.plugin.quality.pmd

public class PMDHandler extends org.xml.sax.helpers.DefaultHandler {
    def findingFile
    def findingLine
    def findingName
    def findingSeverity
    def addFinding

    PMDHandler(def addFinding) {
        this.addFinding = addFinding
    }

    void startElement(String ns, String localName, String qName, org.xml.sax.Attributes attribs) {
        switch (qName) {
           case 'file':
               findingFile = attribs.getValue('name')
               break
           case 'violation':
               findingLine = attribs.getValue('beginline')
               findingName = attribs.getValue('rule')
               findingSeverity = attribs.getValue('ruleset')
               break
        }
    }

    void endElement(String ns, String localName, String qName) {
        switch (qName) {
            case 'violation':
                addFinding('', findingFile, findingLine, findingName, findingSeverity, '', '')
                break
        }
    }
}