/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.*
import com.urbancode.air.plugin.quality.pmd.*

final def workDir = new File('.').canonicalFile
final def workDirPath = workDir.getCanonicalPath()
def apTool = new AirPluginTool(this.args[0], this.args[1])
def props = apTool.getStepProperties()

final File resourceHome = new File(System.getenv()['PLUGIN_HOME'])
final def buildLifeId = System.getenv('BUILD_LIFE_ID')
final def outputFile = new File(props['outputFile']).absoluteFile
final def reportName = props['reportName'] ? props['reportName'] : 'PMD Report'

if (!outputFile.isFile()) {
    if (!outputFile.exists()) {
        println("PMD report file $outputFile.absolutePath does not exist!")
    }
    else {
        println("PMD report file $outputFile.absolutePath is not a file!")
    }
    System.exit(1)
}

XMLHelper helper = new XMLHelper()
helper.uploadResult(reportName, buildLifeId, outputFile, workDirPath)