/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.*
import com.urbancode.air.plugin.quality.pmd.*

final def workDir = new File('.').canonicalFile
final def workDirPath = workDir.getCanonicalPath()
def apTool = new AirPluginTool(this.args[0], this.args[1])
def props = apTool.getStepProperties()

final File resourceHome = new File(System.getenv()['PLUGIN_HOME'])
final def buildLifeId = System.getenv('BUILD_LIFE_ID')
final def includes = props['outputFile']
final def excludes = props['excludes']
final def reportName = props['reportName'] ? props['reportName'] : 'PMD Report'

try {
    def fileSet = new FileSet(workDir)
    fileSet.include(includes)
    fileSet.exclude(excludes)
    
    if (includes) {
        println "Reporting on all files in ${includes}"
    }
    if (excludes) {
        println "Excluding files in ${excludes}"
    }
    
    def reportFiles = []
    fileSet.files().each { file->
        if (file.size() > 0) {
            println 'Report File identified to be included in the PMD Report: ' + file
            reportFiles << file
        }
    }
    
    if (reportFiles.size() > 0) {
        XMLHelper helper = new XMLHelper()
        helper.uploadResult(reportName, buildLifeId, reportFiles, workDirPath)
    }
    else {
        println 'No report files found to upload'
    }
}
catch (Exception e) {
    println e
    System.exit 1
}