/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.query;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.query.QueryFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
public class QueryResult<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<T> results;
    private long totalRecords = 0L;
    private QueryFilter filter;

    public QueryResult(QueryFilter filter) {
        this.filter = filter;
    }

    public void setResults(Collection<T> results) {
        this.results = new ArrayList<T>();
        for (T result : results) {
            this.results.add(result);
        }
    }

    public void setResults(T[] results) {
        this.results = new ArrayList<T>();
        for (T result : results) {
            this.results.add(result);
        }
    }

    public List<T> getResults() {
        return Collections.unmodifiableList(this.results);
    }

    public void setTotalRecords(long totalRecords) {
        this.totalRecords = totalRecords;
    }

    public long getTotalRecords() {
        return this.totalRecords;
    }

    public String getContentRangeString() {
        long start = this.filter.getRowsPerPage() * (this.filter.getPageNumber() - 1);
        long end = start + (long)(this.filter.getRowsPerPage() - 1);
        if (end > this.totalRecords) {
            end = this.totalRecords;
        }
        return String.format("%d-%d/%d", start, end, this.totalRecords);
    }
}

