/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.*

final def apTool = new AirPluginTool(args[0], args[1])

//------------------------------------------------------------------------------
// GET ALL INPUT PARAMETERS 
//------------------------------------------------------------------------------

final def  workDir        = new File('.').canonicalFile
final File resourceHome   = new File(System.getenv()['PLUGIN_HOME'])
final def  props          = apTool.getStepProperties()
final def dir             = new File(workDir, props['source/dirOffset'] ?: '.').canonicalFile // get checkout directory

 println "Deleting directory contents for $dir"
 dir.listFiles().each{ file ->
     boolean success = false;
     if (file.isFile()) {
         println "Deleting file '$file'"
         success = file.delete()
     }
     else if (file.isDirectory()){
         println "Deleting directory '$file'"
         success = file.deleteDir()
     }
     if (!success) {
         println("Failed to delete $file")
     }
 }
 println "Done deleting directory contents for $dir"