/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/


switch (clientSpecPolicy) {
    case 'existing': 
        if (directoryOffset) {
            errors.directoryOffset = 'A directory offset can only be used when creating a new clinetspec from a template.'
        }
        break;

    case 'template': 
        if (!clientspecTemplateName) {
            errors.clientspecTemplateName = 'Please Specify a Template name.'
        }
        break;

    case 'literal': 
        if (!clientspec) {
            errors.clientspec = 'Please specify a client-spec.'
        }
        break;
        
    default:
        errors.clientSpecPolicy = 'Unknown clientspec creation policy ['+clientSpecPolicy+'] specified.'
        break;
}

if (clientSpecPolicy != 'template') {
    if (clientspecTemplateName) {
        errors.clientspecTemplateName = 'A template can only be specified when creating a new clientspec.'
    }
}

if (clientSpecPolicy != 'literal') {
    if (clientspec) {
        errors.clientspec = 'A literal clientspec can only be specified when creating a new (non-template) clientspec.'
    }
}